/*
 * Decompiled with CFR 0.152.
 */
package com.roguewave.chart.richtext.v2_1;

import com.roguewave.chart.richtext.v2_1.BlockContext;
import com.roguewave.chart.richtext.v2_1.TextBlock;
import java.awt.Graphics;
import java.util.Vector;

public class VConcatenation
implements TextBlock {
    Vector blocks_ = new Vector();

    public void addBlock(TextBlock block) {
        this.blocks_.addElement(block);
    }

    public int getHeight(BlockContext bc) {
        int height = 0;
        for (int i = 0; i < this.blocks_.size(); ++i) {
            height += ((TextBlock)this.blocks_.elementAt(i)).getHeight(bc);
        }
        return height;
    }

    public int getWidth(BlockContext bc) {
        int width = 0;
        for (int i = 0; i < this.blocks_.size(); ++i) {
            int blockWidth = ((TextBlock)this.blocks_.elementAt(i)).getWidth(bc);
            if (blockWidth <= width) continue;
            width = blockWidth;
        }
        return width;
    }

    public int getAscent(BlockContext bc) {
        TextBlock block = (TextBlock)this.blocks_.elementAt(this.blocks_.size() - 1);
        return this.getHeight(bc) - block.getHeight(bc) + block.getAscent(bc);
    }

    public void init(BlockContext bc) {
        for (int i = 0; i < this.blocks_.size(); ++i) {
            ((TextBlock)this.blocks_.elementAt(i)).init(bc);
        }
    }

    public void render(BlockContext bc) {
        int x = bc.getX();
        int y = bc.getY();
        Graphics g = bc.getGraphics();
        int alignment = bc.getAlignment();
        int width = this.getWidth(bc);
        BlockContext context = new BlockContext(x, y, g);
        for (int i = 0; i < this.blocks_.size(); ++i) {
            TextBlock block = (TextBlock)this.blocks_.elementAt(i);
            switch (alignment) {
                case 1: {
                    context.setX(x + (width - block.getWidth(context)) / 2);
                    break;
                }
                case 2: {
                    context.setX(x + width - block.getWidth(context));
                    break;
                }
            }
            block.render(context);
            context.setY(y += block.getHeight(context));
        }
    }
}

